/*!\file Dux
 * \brief: diff between observed and modeled velocity
 */

#include "./Dux.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../SurfaceAreax/SurfaceAreax.h"

void Dux( Vec* pdu_g, DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, 
		DataSet* materials, Parameters* parameters,int analysis_type,int sub_analysis_type){

	/*Intermediary*/
	int i;
	int gsize;
	int found;
	double fit=-1;
	double S;
	Element* element=NULL;

	/*output: */
	Vec du_g=NULL;

	/*First, get elements and loads configured: */
	elements->  Configure(elements,loads, nodes, vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes, vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes, vertices, materials,parameters);

	/*Compute surface area: */
	SurfaceAreax(&S,elements,nodes,vertices, loads,materials,parameters,analysis_type,sub_analysis_type);

	/*add surface area to elements :*/
	elements->UpdateInputsFromVector(&S,SurfaceAreaEnum,ConstantEnum);
	
	/*Get size of matrix: */
	gsize=nodes->NumberOfDofs(analysis_type);

	/*Allocate du_g: */
	du_g=NewVec(gsize);

	/*Compute velocity difference: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->Du(du_g,analysis_type,sub_analysis_type);
	}

	/*Assemble vector: */
	VecAssemblyBegin(du_g);
	VecAssemblyEnd(du_g);

	/*Assign output pointers: */
	*pdu_g=du_g;
	
}
