/*!\file: bedslope_core.cpp
 * \brief: core of the bed slope solution 
 */ 

#include "./solutions.h"
#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules/modules.h"

void bedslope_core(FemModel* femmodel){

	/*parameters: */
	int verbose;
	int dim;
	bool isstokes;
	bool ishutter;

	Vec slopex=NULL;
	Vec slopey=NULL;

	/*Recover some parameters: */
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&dim,DimEnum);

	if(verbose)_printf_("%s\n","computing slope...");

	/*Call on core computations: */
	solver_linear(&slopex,femmodel,SlopeComputeAnalysisEnum,BedSlopeXAnalysisEnum);
	solver_linear(&slopey,femmodel,SlopeComputeAnalysisEnum,BedSlopeYAnalysisEnum);
	
	/*Plug solution into inputs: */
	UpdateInputsFromSolutionx( femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,slopex,SlopeComputeAnalysisEnum,BedSlopeXAnalysisEnum);
	UpdateInputsFromSolutionx( femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,slopey,SlopeComputeAnalysisEnum,BedSlopeYAnalysisEnum);

	/*extrude if we are in 3D: */
	if (dim==3){
		if(verbose)_printf_("%s\n","extruding slope in 3d...");
		InputsExtrudex( femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,BedSlopeXEnum,0);
		InputsExtrudex( femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,BedSlopeYEnum,0);
	}

	/*Free ressources:*/
	VecFree(&slopex);
	VecFree(&slopey);
}
