/*!\file: CreateDataSets
 * \brief general driver for creating all datasets that make a finite element iomodel
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "./ModelProcessorx.h"


void CreateDataSets(DataSet** pelements,DataSet** pnodes, DataSet** pvertices, DataSet** pmaterials, DataSet** pconstraints, DataSet** ploads,Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int analysis_type,int nummodels,int analysis_counter){

	bool continuous=true;
	DataSet* elements=NULL;
			
	/*Create elements, vertices and materials, independent of analysis_type: */
	CreateElementsVerticesAndMaterials(pelements, pvertices, pmaterials, iomodel,iomodel_handle,nummodels);

	/*Recover elements, for future update: */
	elements=*pelements;

	/*Now, branch onto analysis dependent model generation: */
	switch(analysis_type){
		case  DiagnosticHorizAnalysisEnum:
			CreateNodesDiagnosticHoriz(pnodes, iomodel,iomodel_handle);
			CreateConstraintsDiagnosticHoriz(pconstraints,iomodel,iomodel_handle);
			CreateLoadsDiagnosticHoriz(ploads,iomodel,iomodel_handle);
			UpdateElementsDiagnosticHoriz(elements,iomodel,iomodel_handle,analysis_counter,analysis_type);
			break;
		
		case  DiagnosticVertAnalysisEnum:
			CreateNodesDiagnosticVert(pnodes, iomodel,iomodel_handle);
			CreateConstraintsDiagnosticVert(pconstraints,iomodel,iomodel_handle);
			CreateLoadsDiagnosticVert(ploads,iomodel,iomodel_handle);
			UpdateElementsDiagnosticVert(elements,iomodel,iomodel_handle,analysis_counter,analysis_type);
			break;
	
		case DiagnosticStokesAnalysisEnum:
			CreateNodesDiagnosticStokes(pnodes, iomodel,iomodel_handle);
			CreateConstraintsDiagnosticStokes(pconstraints,iomodel,iomodel_handle);
			CreateLoadsDiagnosticStokes(ploads,iomodel,iomodel_handle);
			UpdateElementsDiagnosticStokes(elements,iomodel,iomodel_handle,analysis_counter,analysis_type);
			break;
	
		case DiagnosticHutterAnalysisEnum:
			CreateNodesDiagnosticHutter(pnodes, iomodel,iomodel_handle);
			CreateConstraintsDiagnosticHutter(pconstraints,iomodel,iomodel_handle);
			CreateLoadsDiagnosticHutter(ploads,iomodel,iomodel_handle);
			UpdateElementsDiagnosticHutter(elements,iomodel,iomodel_handle,analysis_counter,analysis_type);
			break;

		case SlopeComputeAnalysisEnum:
			CreateNodesSlopeCompute(pnodes, iomodel,iomodel_handle);
			CreateConstraintsSlopeCompute(pconstraints,iomodel,iomodel_handle);
			CreateLoadsSlopeCompute(ploads,iomodel,iomodel_handle);
			UpdateElementsSlopeCompute(elements,iomodel,iomodel_handle,analysis_counter,analysis_type);
			break;

		case ThermalAnalysisEnum:
			CreateNodesThermal(pnodes, iomodel,iomodel_handle);
			CreateConstraintsThermal(pconstraints,iomodel,iomodel_handle);
			CreateLoadsThermal(ploads,iomodel,iomodel_handle);
			UpdateElementsThermal(elements,iomodel,iomodel_handle,analysis_counter,analysis_type);
			break;

		case MeltingAnalysisEnum:
			CreateNodesMelting(pnodes, iomodel,iomodel_handle);
			CreateConstraintsMelting(pconstraints,iomodel,iomodel_handle);
			CreateLoadsMelting(ploads,iomodel,iomodel_handle);
			UpdateElementsMelting(elements,iomodel,iomodel_handle,analysis_counter,analysis_type);
			break;

		case PrognosticAnalysisEnum:
			CreateNodesPrognostic(pnodes, iomodel,iomodel_handle);
			CreateConstraintsPrognostic(pconstraints,iomodel,iomodel_handle);
			CreateLoadsPrognostic(ploads,iomodel,iomodel_handle);
			UpdateElementsPrognostic(elements,iomodel,iomodel_handle,analysis_counter,analysis_type);
			break;

		case Prognostic2AnalysisEnum:
			CreateNodesPrognostic2(pnodes, iomodel,iomodel_handle);
			CreateConstraintsPrognostic2(pconstraints,iomodel,iomodel_handle);
			CreateLoadsPrognostic2(ploads,iomodel,iomodel_handle);
			UpdateElementsPrognostic2(elements,iomodel,iomodel_handle,analysis_counter,analysis_type);
			break;

		case BalancedthicknessAnalysisEnum:
			CreateNodesBalancedthickness(pnodes, iomodel,iomodel_handle);
			CreateConstraintsBalancedthickness(pconstraints,iomodel,iomodel_handle);
			CreateLoadsBalancedthickness(ploads,iomodel,iomodel_handle);
			UpdateElementsBalancedthickness(elements,iomodel,iomodel_handle,analysis_counter,analysis_type);
			break;

		case Balancedthickness2AnalysisEnum:
			CreateNodesBalancedthickness2(pnodes, iomodel,iomodel_handle);
			CreateConstraintsBalancedthickness2(pconstraints,iomodel,iomodel_handle);
			CreateLoadsBalancedthickness2(ploads,iomodel,iomodel_handle);
			UpdateElementsBalancedthickness2(elements,iomodel,iomodel_handle,analysis_counter,analysis_type);
			break;
		case BalancedvelocitiesAnalysisEnum:
			CreateNodesBalancedvelocities(pnodes, iomodel,iomodel_handle);
			CreateConstraintsBalancedvelocities(pconstraints,iomodel,iomodel_handle);
			CreateLoadsBalancedvelocities(ploads,iomodel,iomodel_handle);
			UpdateElementsBalancedvelocities(elements,iomodel,iomodel_handle,analysis_counter,analysis_type);
			break;
		default:
			ISSMERROR("%s%s%s"," analysis_type: ",EnumAsString(analysis_type)," not supported yet!");
	}
	
	/*Generate objects that are not dependent on any analysis_type: */
	CreateParameters(pparameters,iomodel,iomodel_handle,analysis_type);

	/*Sort datasets: */
	SortDataSets(pelements,pnodes,pvertices, ploads, pmaterials, pconstraints, pparameters);

	/*Update counters, because we have created more nodes, loads and constraints, and ids for objects created in next call to CreateDataSets
	 * will need to start at the end of the updated counters: */
	UpdateCounters(iomodel,pnodes,ploads,pconstraints);

}
