/*
 * UpdateElementsDiagnosticHutter:
 */

#include "../../../DataSet/DataSet.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsDiagnosticHutter(DataSet* elements, IoModel* iomodel,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type){

	/*Intermediary*/
	int i;
	int counter;
	Element* element=NULL;

	/*Now, is the flag hutter on? otherwise, do nothing: */
	if (!iomodel->ishutter)goto cleanup_and_return;

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->gridonsurface,NULL,NULL,iomodel_handle,"gridonsurface");
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->drag_coefficient,NULL,NULL,iomodel_handle,"drag_coefficient");
	IoModelFetchData(&iomodel->rheology_B,NULL,NULL,iomodel_handle,"rheology_B");
	IoModelFetchData(&iomodel->rheology_n,NULL,NULL,iomodel_handle,"rheology_n");
	IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,"elements_type");
	IoModelFetchData(&iomodel->elementonbed,NULL,NULL,iomodel_handle,"elementonbed");
	IoModelFetchData(&iomodel->elementonsurface,NULL,NULL,iomodel_handle,"elementonsurface");
	IoModelFetchData(&iomodel->elementonwater,NULL,NULL,iomodel_handle,"elementonwater");
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	IoModelFetchData(&iomodel->upperelements,NULL,NULL,iomodel_handle,"upperelements");
	IoModelFetchData(&iomodel->lowerelements,NULL,NULL,iomodel_handle,"lowerelements");

	/*Update elements: */
	counter=0;
	for (i=0;i<elements->Size();i++){
		if(iomodel->my_elements[i]){
			element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}
	cleanup_and_return:

	/*Free data: */
	xfree((void**)&iomodel->gridonhutter);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->surface);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->gridonsurface);
	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->drag_coefficient);
	xfree((void**)&iomodel->rheology_B);
	xfree((void**)&iomodel->rheology_n);
	xfree((void**)&iomodel->elements_type);
	xfree((void**)&iomodel->elementonbed);
	xfree((void**)&iomodel->elementonsurface);
	xfree((void**)&iomodel->elementonwater);
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->upperelements);
	xfree((void**)&iomodel->lowerelements);
}
