/*!\file ConfigureObjectsx
 * \brief: configure objects in elements and loads to link in with nodes
 */

#include "./ConfigureObjectsx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

int	ConfigureObjectsx( DataSet* elements, DataSet* loads, DataSet* nodes, DataSet* vertices, DataSet* materials,Parameters* parameters,int analysis_counter,int analysis_type){

	/*Intermediary*/
	int noerr=1;
	int i;
	Element* element=NULL;
	Load* load=NULL;
	Node* node=NULL;
	
	//_printf_("      Configuring elements...\n");
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->Configure(elements,loads,nodes,materials,parameters,analysis_counter);
	}
	//_printf_("      Configuring loads...\n");
	for (i=0;i<loads->Size();i++){
		load=(Load*)loads->GetObjectByOffset(i);
		if (load->InAnalysis(analysis_type)){
			load->Configure(elements,loads,nodes,vertices,materials,parameters);
		}
	}
	//_printf_("      Configuring nodes...\n");
	for (i=0;i<nodes->Size();i++){
		node=(Node*)nodes->GetObjectByOffset(i);
		if(node->InAnalysis(analysis_type)){
				node->Configure(nodes,vertices);
		}
	}

	return noerr;
}
