/*!\file: ResetBoundaryConditions.cpp
 * \brief: change boundary conditions of a model, using a solution vector from another analysis
 */ 

#include "../objects/objects.h"
#include "../modules/modules.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void ResetBoundaryConditions(FemModel* femmodel, int analysis_type, int sub_analysis_type){
	
	int verbose=0;
	Vec ug=NULL;
			
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	if(verbose)_printf_("%s\n"," updating boundary conditions...");
			
	GetSolutionFromInputsx( &ug, femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,  femmodel->parameters, analysis_type,sub_analysis_type);

	/*set current analysis: */
	femmodel->SetCurrentAnalysis(analysis_type);
	
	/*For this analysis_type, free existing boundary condition vectors: */

	//global dof set
	VecFree(&femmodel->yg[femmodel->analysis_counter]->vector); 
	//in the s-set
	VecFree(&femmodel->ys[analysis_counter]);

	//Now, duplicate ug (the solution vector) into the boundary conditions vector on the g-set
	VecDuplicatePatch(&femmodel->yg[analysis_counter]->vector,ug);
	
	//Reduce from g to s set
	Reducevectorgtosx(&femmodel->ys[analysis_counter],femmodel->yg[analysis_counter]->vector,femmodel->nodesets[analysis_counter]);

	/*Free ressources:*/
	VecFree(&ug);

}
