/*!\file: ResetBoundaryConditions.cpp
 * \brief: change boundary conditions of a model, using a solution vector from another analysis
 */ 

#include "../objects/objects.h"
#include "../modules/modules.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void ResetBoundaryConditions(FemModel* femmodel, int analysis_type, Vec ug){
	
	int verbose=0;
			
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	if(verbose)_printf_("%s\n"," updating boundary conditions...");

	femmodel->SetCurrentAnalysis(analysis_type);
	
	/*First, for this analysis_type, free existing boundary condition vectors: */

	//global dof set
	VecFree(&femmodel->yg[femmodel->analysis_counter]->vector); 
	//in the s-set
	VecFree(&femmodel->ys[analysis_counter]);

	//Now, duplicate ug (the solution vector) into the boundary conditions vector on the g-set
	VecDuplicatePatch(&femmodel->yg[analysis_counter]->vector,ug);
	
	//Reduce from g to s set
	Reducevectorgtosx(&femmodel->ys[analysis_counter],femmodel->yg[analysis_counter]->vector,femmodel->nodesets[analysis_counter]);

}
