/*
 * solutions.h: 
 */

#ifndef PARALLEL_H_
#define PARALLEL_H_

#include "../objects/objects.h"
#include "../io/io.h"

struct OptArgs;
class FemModel;

/*cores: */
Results* gradjcompute_core(Model* model);
Results* diagnostic_core(Model* model);
Results* prognostic_core(Model* model);
Results* prognostic2_core(Model* model);
Results* balancedthickness_core(Model* model);
Results* balancedthickness2_core(Model* model);
Results* balancedvelocities_core(Model* model);
Results* slopecompute_core(Model* model);
Results* control_core(Model* model);
Results* steadystate_core(Model* model);
Results* transient_core(Model* model);
Results* transient_core_2d(Model* model);
Results* transient_core_3d(Model* model);
Results* thermal_core(Model* model);

/*computational cores: */
void thermal_core_nonlinear(Vec* ptg,double* pmelting_offset,FemModel* fem,int analysis_type,int sub_analysis_type);
void diagnostic_core_nonlinear(Vec* pug,Mat* pK_ff0,Mat* pK_fs0, DataSet* loads, FemModel* fem,int analysis_type,int sub_analysis_type);
void diagnostic_core_linear(Vec* ppg,FemModel* fem,int  analysis_type,int sub_analysis_type);
void solver_linear(Vec* ppg,FemModel* fem,int  analysis_type,int sub_analysis_type);
void slope_core(FemModel* fem,int sub_analysis_type);


//int GradJOrth(WorkspaceParams* workspaceparams);
void convergence(int* pconverged, Mat K_ff,Vec p_f,Vec u_f,Vec u_f_old,Parameters* parameters);

int GoldenSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*),FemModel* femmodel);

int BrentSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*),FemModel* femmodel);
	
double objectivefunctionC(double search_scalar,OptArgs* optargs);

int GradJSearch(double* search_vector,FemModel* femmodel,int step);
//int GradJCheck(WorkspaceParams* workspaceparams,int step,int status);

//int ParameterUpdate(double* search_vector,int step, WorkspaceParams* workspaceparams,BatchParams* batchparams);
void WriteLockFile(char* filename);

void ControlInitialization(Model* model);
void ControlRestart(Model* model,double* param_g);

void CreateFemModel(FemModel* femmodel,ConstDataHandle MODEL,int analysis_type,int sub_analysis_type);
//int BatchDebug(Mat* Kgg,Vec* pg,FemModel* femmodel,char* filename);

#endif
