/*!\file: slope_core.cpp
 * \brief: core of the slope solution 
 */ 

#include "./solutions.h"
#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules/modules.h"

void slope_core(FemModel* femmodel, int sub_analysis_type){

	/*parameters: */
	int verbose;
	int dim;
	bool isstokes;
	bool ishutter;

	/*output: */
	Vec slope=NULL;

	/*Recover some parameters: */
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&dim,DimEnum);
	femmodel->parameters->FindParam(&isstokes,IsStokesEnum);
	femmodel->parameters->FindParam(&ishutter,IsHutterEnum);

	if(verbose)_printf_("%s\n","computing slope...");

	/*Early return possible? */
	if(!ishutter && AnalysisEnum==SurfaceAnalysisEnum) return;
	if(!isstokes && AnalysisEnum==BedAnalysisEnum) return;

	/*Call on core computations: */
	solver_linear(&slope,femmodel,SlopecomputeAnalysisEnum,sub_analysis_type);
	
	/*Plug solution into inputs: */
	UpdateInputsFromSolutionx( femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,slope,analysis_type, sub_analysis_type);

	/*extrude if we are in 3D: */
	if (dim==3){
		if(verbose)_printf_("%s\n","extruding slope in 3d...");
		switch(sub_analysis_type){
			case SurfaceXAnalysisEnum:
				InputsExtrudex( femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,SurfaceSlopeXEnum,0);
			case SurfaceYAnalysisEnum:
				InputsExtrudex( femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,SurfaceSlopeYEnum,0);
			case BedXAnalysisEnum:
				InputsExtrudex( femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,BedSlopeXEnum,0);
			case BedYAnalysisEnum:
				InputsExtrudex( femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,BedSlopeYEnum,0);
			default: ISSMERROR("%s%s%s"," sub_analysis_type ",EnumAsString(sub_analysis_type)," not supported yet!");
		}
	}

	/*Free ressources:*/
	VecFree(&slope);
}
