/*
 * CreateConstraintsPrognostic.c:
 */

#include "../../../DataSet/DataSet.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../io/io.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsPrognostic(DataSet** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i;
	int count;
	
	/*Output*/
	DataSet* constraints = NULL;
	Spc*    spc  = NULL;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new DataSet(ConstraintsEnum);

	/*Fetch data: */
	IoModelFetchData(&iomodel->spcthickness,NULL,NULL,iomodel_handle,"spcthickness");

	/*Initialize counter*/
	count=0;

	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i]==1)){

			if ((int)iomodel->spcthickness[2*i]){

				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,*(iomodel->spcthickness+2*i+1),PrognosticAnalysisEnum));
				count++;
			}
		} //if((my_vertices[i]==1))
	}

	/*Free data: */
	xfree((void**)&iomodel->spcthickness);
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
