/*
 * CreateConstraintsDiagnosticHoriz.c:
 */

#include "../../../DataSet/DataSet.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsDiagnosticVert(DataSet** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i;
	int count;

	/*Output*/
	DataSet* constraints = NULL;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new DataSet(ConstraintsEnum);

	/*return if 2d mesh*/
	if (iomodel->dim==2) goto cleanup_and_return;

	/*Fetch data: */
	IoModelFetchData(&iomodel->spcvelocity,NULL,NULL,iomodel_handle,"spcvelocity");

	/*Initialize counter*/
	count=0;

	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){

		/*keep only this partition's nodes:*/
		if(iomodel->my_vertices[i]){

			if ((int)iomodel->spcvelocity[6*i+2]){
				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,
								*(iomodel->spcvelocity+6*i+5)/iomodel->yts,DiagnosticVertAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
				count++;

			}
		} 
	}

	/*Free data: */
	xfree((void**)&iomodel->spcvelocity);

	cleanup_and_return:

	/*Assign output pointer: */
	*pconstraints=constraints;
}
