/*!\file Penpair.h
 * \brief: header file for penpair object */

#ifndef _PENPAIR_H_
#define _PENPAIR_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
#include "../Node.h"
#include "../Elements/Element.h"

class Element;
/*}}}*/

class Penpair: public Load{

	private: 
		int		id;
		int analysis_type;
		
		Hook hnodes;  //hook to 2 nodes

	public:

		/*constructors: {{{1*/
		Penpair();
		Penpair(int penpair_id,int* penpair_node_ids,int analysis_type);
		Penpair(int penpair_id,Hook* penpair_hnodes,int analysis_type);
		~Penpair();
		Object* copy();
		/*}}}*/
		/*object management: {{{1*/
		void  Configure(DataSet* elements,DataSet* loads,DataSet* nodes,DataSet* vertices,DataSet* materials,Parameters* parameters);
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void  UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void  UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}
		bool  InAnalysis(int analysis_type);
		/*}}}*/
		/*numerics: {{{1*/
		void  CreateKMatrix(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, int analysis_type,int sub_analysis_type);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVector(Vec pg,double kmax,int analysis_type,int sub_analysis_type);
		/*}}}*/
};

#endif  /* _PENPAIR_H_ */


