/*! \file CreateLoadsMelting.c:
 */

#include "../../../DataSet/DataSet.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateLoadsMelting(DataSet** ploads, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i;

	/*DataSet*/
	DataSet*    loads    = NULL;

	/*if 2d: Error*/
	if (iomodel->dim==2) ISSMERROR("2d meshes not supported yet");

	/*Recover pointer: */
	loads=*ploads;

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new DataSet(LoadsEnum);

	//create penalties for grids: no grid can have a temperature over the melting point
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	CreateSingleNodeToElementConnectivity(iomodel);

	for (i=0;i<iomodel->numberofvertices;i++){
		
		if((iomodel->my_vertices[i]==1)){

			if (iomodel->gridonbed[i]){ 
				
				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,MeltingAnalysisEnum));
			}
		}
	}
	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->singlenodetoelementconnectivity);

	/*Assign output pointer: */
	*ploads=loads;
}
