%-----------------------------------------------------------------------
%	CreateFEMModel.m: from a matlab ISSM @model class object, create a finite element 
%                  model structure, with "c" code datasets (elements, nodes, loads,  constraints, 
%                  parameters, partitioning vectors.
%
%-----------------------------------------------------------------------

function  m=CreateFEMModel(md,analyses)
	
	displaystring(md.verbose,'\n   reading data from model %s...',md.name);
	[m.elements,m.nodes,m.vertices,m.constraints,m.loads,m.materials,m.parameters]=ModelProcessor(md,analyses);

	for i=1:length(analyses),

		displaystring(md.verbose,'%s','   generating degrees of freedom...');
		if ~isfield(m,'part') [m.vertices,m.part,m.tpart]=VerticesDof(vertices, m.parameters);
		[m.nodes]=NodesDof(m.nodes,m.parameters);

		displaystring(md.verbose,'%s','   generating single point constraints...');
		[m.nodes,m.yg(i)]=SpcNodes(m.nodes,m.constraints,analyses[i]);

		displaystring(md.verbose,'%s','   generating rigid body constraints...');
		[m.Rmg(i),m.nodes]=MpcNodes(m.nodes,m.constraints,analyses[i]);

		displaystring(md.verbose,'%s','   generating node sets...');
		m.nodesets(i)=BuildNodeSets(m.nodes,analyses[i]);

		displaystring(md.verbose,'%s','   reducing single point constraints vector...');
		m.ys(i)=Reducevectorgtos(m.yg(i).vector,m.nodesets(i));
		
		displaystring(md.verbose,'%s','   normalizing rigid body constraints matrix...');
		m.Gmn(i)= NormalizeConstraints(m.Rmg(i),m.nodesets(i));

		displaystring(md.verbose,'%s','   configuring element and loads...');
		[m.elements,m.loads,m.nodes,m.parameters] = ConfigureObjects( m.elements, m.loads, m.nodes, m.vertices,m.materials,m.parameters);
	end

end
