/*!\file Numericalflux.h
 * \brief: header file for icefront object
 */

#ifndef _NUMERICALFLUX_H_
#define _NUMERICALFLUX_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
class Hook;
class Parameters;
class Inputs;
class IoModel;

/*}}}*/

class Numericalflux: public Load {

	public: 
		int         id;

		Hook        helements;
		Hook        hnodes;
		Parameters *parameters;
		Inputs     *inputs;


		/*Constructors {{{1*/
		Numericalflux();
		Numericalflux(int numericalflux_id,int* numericalflux_node_ids,int numnodes, int* numericalflux_element_ids, int numelements);
		Numericalflux(int numericalflux_id,Hook* numericalflux_hnodes, Hook* numericalflux_helements, Parameters* parameters, Inputs* numericalflux_inputs);
		Numericalflux(int numericalflux_id,int i, IoModel* iomodel);
		~Numericalflux();
		/*}}}*/
		/*Object management: {{{1*/
		Object* copy();
		void  Configure(DataSet* elements,DataSet* loads,DataSet* nodes,DataSet* vertices,DataSet* materials,Parameters* parameters);
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}
		bool    InAnalysis(int analysis_type);

		/*}}}*/
		/*Numerics: {{{1*/
		void  GetJacobianDeterminant(double* pJdet,double xyz_list[4][3], double gauss_coord);
		void  GetNodalFunctions(double* l1l4, double gauss_coord);
		void  DistributeNumDofs(int* numdofspernode,int analysis_type,int sub_analysis_type);
		void  GetB(double* B, double gauss_coord);
		void  GetL(double* L, double gauss_coord,int numdof);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetNormal(double* normal,double xyz_list[4][3]);
		void  GetParameterValue(double* pp, double* plist, double gauss_coord);
		void  UpdateFromInputs(void* inputs);
		
		void  CreateKMatrix(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixInternal(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixBoundary(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg,  int analysis_type,int sub_analysis_type);
		void  CreatePVectorInternal(Vec pg,int analysis_type,int sub_analysis_type);
		void  CreatePVectorBoundary(Vec pg,int analysis_type,int sub_analysis_type);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVector(Vec pg,double kmax,int analysis_type,int sub_analysis_type);
		/*}}}*/

};

#endif  /* _NUMERICALFLUX_H_ */
