/*!\file Rgb.h
 * \brief: header file for rgb object
 */

#ifndef _RGB_H_
#define _RGB_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
class DataSet;
/*}}}*/

class Rgb: public Object{

	private: 
		int	id; /*! id, to track it*/
		int	nodeid1; 
		int	nodeid2; 
		int dof; /*!component*/
		int analysis_type;

	public:

		Rgb();
		Rgb(int rgb_id,int rgb_nodeid1,int rgb_nodeid2, int rgb_dof,int analysis_type);
		~Rgb();

		void   Echo();
		void   DeepEcho();
		void   Marshall(char** pmarshalled_dataset);
		int    MarshallSize();
		void   Demarshall(char** pmarshalled_dataset);
		int    Enum();
		int    Id(); 
		int    MyRank();
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}

		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}


		/*non virtual: */
		int    GetNodeId1();
		int    GetNodeId2();
		int    GetDof();
		Object* copy();
		bool  InAnalysis(int analysis_type);


};

#endif  /* _RGB_H_ */
