/*! \file CreateLoadsDiagnosticHoriz.c:
 */

#include "../../../DataSet/DataSet.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateLoadsDiagnosticHoriz(DataSet** ploads, IoModel* iomodel,ConstDataHandle iomodel_handle){

	DataSet*    loads    = NULL;
	Icefront*   icefront = NULL;
	Riftfront*  riftfront= NULL;

	int segment_width;
	int element;
	int i;
	int count=0;

	/*Recover pointer: */
	loads=*ploads;

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new DataSet(LoadsEnum);

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!iomodel->ismacayealpattyn)goto cleanup_and_return;
	
	/*Create pressure loads as boundary conditions. Pay attention to the partitioning if we are running in parallel (the grids
	 * referenced by a certain load must belong to the cluster node): */
	IoModelFetchData(&iomodel->pressureload,&iomodel->numberofpressureloads,NULL,iomodel_handle,"pressureload");
	IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,"elements_type");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");

	/*Initialize counter: */
	count=0;

	/*First load data:*/
	for (i=0;i<iomodel->numberofpressureloads;i++){
		
		/*Retrieve element to which this icefront belongs: */
		if (iomodel->dim==2) segment_width=4; 
		else segment_width=6;
		element=(int)(*(iomodel->pressureload+segment_width*i+segment_width-2)-1); //element is in the penultimate column (grid1 grid2 ... elem fill)

		/*Now, if this element is not in the partition, pass: */
		if(!iomodel->my_elements[element]) continue;
		
		/*Do not create ice front if Hutter or Stokes elements*/
		if ((int)*(iomodel->elements_type+2*element+0)==(HutterFormulationEnum || StokesFormulationEnum)) continue;

		/*Create and  add load: */
		loads->AddObject(new Icefront(iomodel->loadcounter+count+1,i,iomodel,DiagnosticHorizAnalysisEnum));
		count++;

	}

	/*Free data: */
	xfree((void**)&iomodel->pressureload);
	xfree((void**)&iomodel->elements_type);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);

	/*Create Riffront loads for rifts: */
	IoModelFetchData(&iomodel->riftinfo,&iomodel->numrifts,NULL,iomodel_handle,"riftinfo");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
	IoModelFetchData(&iomodel->gridoniceshelf,NULL,NULL,iomodel_handle,"gridoniceshelf");
	
	if(iomodel->numrifts){
		for(i=0;i<iomodel->numrifts;i++){
				
			if(iomodel->my_elements[(int)*(iomodel->riftinfo+RIFTINFOSIZE*i+2)]){

				loads->AddObject(new Riftfront(iomodel->loadcounter+count+1,i,iomodel,DiagnosticHorizAnalysisEnum));
				count++;
			}
		}
	}
				
	/*free ressources: */
	xfree((void**)&iomodel->riftinfo);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->surface);
	xfree((void**)&iomodel->gridoniceshelf);

	cleanup_and_return:

	/*Assign output pointer: */
	*ploads=loads;

}
