/*
 * CreateConstraintsDiagnosticHoriz.c:
 */

#include "../../../DataSet/DataSet.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"


void	CreateConstraintsDiagnosticHoriz(DataSet** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){


	int i,j;
	int count=0;
	
	DataSet* constraints = NULL;
	Spc*    spc  = NULL;
	Rgb*    rgb  = NULL;
	int     node1,node2;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new DataSet(ConstraintsEnum);
	
	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!iomodel->ismacayealpattyn)goto cleanup_and_return;
	
	/*Spcs: fetch data: */
	IoModelFetchData(&iomodel->spcvelocity,NULL,NULL,iomodel_handle,"spcvelocity");
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");

	/*Initialize counter: */
	count=0;
	
	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
		if(iomodel->my_vertices[i]){

			if ((int)iomodel->spcvelocity[6*i+0] | (int)iomodel->gridonhutter[i]) 
				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,*(iomodel->spcvelocity+6*i+3)/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.

			count++;
			
			if ((int)iomodel->spcvelocity[6*i+1] | (int)iomodel->gridonhutter[i]) 
				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,2,*(iomodel->spcvelocity+6*i+4)/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 2 to vy

			count++;
		}
	}
	  
	/*Free data: */
	xfree((void**)&iomodel->spcvelocity);
	xfree((void**)&iomodel->gridonhutter);

	/*penalty loads: */
	IoModelFetchData(&iomodel->penalties,&iomodel->numpenalties,NULL,iomodel_handle,"penalties");
	
	count=1; //matlab indexing
	if(iomodel->numpenalties){

		for (i=0;i<iomodel->numpenalties;i++){

			for(j=1;j<iomodel->numlayers;j++){
	
				/*We are pairing nodes along a vertical profile.*/
				node1=(int)*(iomodel->penalties+iomodel->numlayers*i)+iomodel->nodecounter;
				node2=(int)*(iomodel->penalties+iomodel->numlayers*i+j)+iomodel->nodecounter;

				constraints->AddObject(new Rgb(iomodel->constraintcounter+count+1,node1,node2,1,DiagnosticHorizAnalysisEnum));  //add count'th Rgb on dof 1 between node1 and node2
				
				count++;
				
				constraints->AddObject(new Rgb(iomodel->constraintcounter+count+1,node1,node2,2),DiagnosticHorizAnalysisEnum);  //add count'th Rgb on dof 1 between node1 and node2

			}
		}
	}

	/*Free data: */
	xfree((void**)&iomodel->penalties);

	cleanup_and_return:

	/*Assign output pointer: */
	*pconstraints=constraints;
}
