/*\file NodesDof.c
 *\brief: build degrees of freedom for every grid.
 */

#include "./NodesDof.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	DataSet* vertices=NULL;
	Parameters* params=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&NodesDofUsage);

	/*Input datasets: */
	FetchData(&nodes,NODESIN);
	FetchData((DataSet**)&params,PARAMS);

	/*!Generate internal degree of freedom numbers: */
	NodesDofx(nodes, params); 

	/*write output datasets: */
	WriteData(NODES,nodes);

	/*Free ressources: */
	delete nodes;
	delete params;
	/*end module: */
	MODULEEND();
}

void NodesDofUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [nodes] = %s(nodes,params);\n",__FUNCT__);
	_printf_("\n");
}
