/*!\file NodesDofx
 * \brief: establish degrees of freedom for all nodes
 */

#include "./NodesDofx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void NodesDofx( DataSet* nodes, Parameters* parameters) {

	int noerr=1;
	int i;

	int  found=0;
	
	/*intermediary: */
	int  numberofnodes;
	int  numberofdofspernode;

	/*First, recover number of vertices and nodes from parameters: */
	found=parameters->FindParam(&numberofnodes,NumberOfNodesEnum);
	if(!found)ISSMERROR(" could not find numberofnodes in parameters");

	/*Recover number of dofs per node: */
	found=parameters->FindParam(&numberofdofspernode,NumberOfDofsPerNodeEnum);
	if(!found)ISSMERROR(" could not find numberofdofspernode in parameters");

	/*Ensure that only for each cpu, the partition border nodes only will be taken into account once 
	 * across the cluster. To do so, we flag all the clone nodes: */
	nodes->FlagClones(numberofnodes);

	/*Go through all nodes, and build degree of freedom lists. Each node gets a fixed number of dofs. When 
	 *a  node has already been distributed dofs on one cpu, all other cpus with the same node cannot distribute it 
	 *anymore. Use clone field to be sure of that: */
	nodes->DistributeDofs(numberofnodes,numberofdofspernode);

}
