/*!\file: UpdateCounter.cpp
 * \brief update counters after adding objects to a dataset.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "./ModelProcessorx.h"

void    UpdateCounter(IoModel* iomodel,DataSet** pnodes,DataSet** ploads, DataSet** pconstraints){

	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* constraints=NULL;

	/*recover pointers: */
	nodes=*pnodes;
	loads=*ploads;
	cosntraints=*pconstraints;


	if(nodes)iomodel->nodecounter=nodes->Size();
	else iomodel->nodecounter=0;

	if(loads)iomodel->loadcounter=loads->Size();
	else iomodel->loadcounter=0;
	
	if(constraints)iomodel->constraintcounter=constraints->Size();
	else iomodel->constraintcounter=0;

}
