/*\file ModelProcessor.c
 *\brief: processes model inputs from the matlab workspace, and transforms them into datasets or vectors 
 *        that will be used throughout the matlab solution sequences.
 */

#include "./ModelProcessor.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){ 

	int i;

	/*inputs: */
	double* analyses=NULL;
	int     numanalyses;

	/* output datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* vertices=NULL;
	DataSet* constraints=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;

	/*input model: */
	IoModel* iomodel=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ModelProcessorUsage);

	/*Fill iomodel with matlab workspace data: */
	iomodel=new IoModel(MODEL); //this routine goes through the entire MODEL matlab class, and starts filling the corresponding "c" code model object.
	FetchData(&analyses,&numanalyses,ANALYSES);

	/*Create datasets, and update for each analysis type: */
	for(i=0;i<numanalyses;i++){
		CreateDataSets(&elements,&nodes,&vertices,&materials,&constraints, &loads, &parameters, iomodel,MODEL,(int)analyses[i],numanalyses,i);
	}
	

	/*Write output data: */
	WriteData(ELEMENTS,elements);
	WriteData(NODES,nodes);
	WriteData(VERTICES,vertices);
	WriteData(CONSTRAINTS,constraints);
	WriteData(LOADS,loads);
	WriteData(MATERIALS,materials);
	WriteData(PARAMETERS,parameters);
	

	/*Free ressources: */
	delete iomodel;
	delete elements;
	delete nodes;
	delete vertices;
	delete constraints;
	delete loads;
	delete materials;
	delete parameters;
	delete analyses;

	/*end module: */
	MODULEEND();
}
	
void ModelProcessorUsage(void) {
	_printf_("\n");
	_printf_("   usage: [elements,grids,constraints,loads,materials,parameters,part,tpart]=ModelProcessor(model,analyses)\n");
	_printf_("   where: model is an instance of the matlab @model class and analyses is a list of analysis types being performed.\n");
	_printf_("\n");
}
