/*!\file SpcNodesx
 * \brief: establish single point constraints on all grids, as well as constraints vector.
 */

#include "./SpcNodesx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void SpcNodesx(Vec* pyg, DataSet* nodes,DataSet* constraints,analysis_type){

	int i;
	int numberofdofs;
	int gsize;

	/*output: */
	Vec* yg=NULL;

	/*First, recover number of dofs from nodes: */
	numberofdofs=nodes->NumberOfDofs(analysis_type);

	if(numberofdofs){
		
		/*Allocate yg: */
		yg=NewVec(numberofdofs);

		/*Now, go through constraints, and update the nodes and the constraint vector at the same time: */
		constraints->SetupSpcs(nodes,yg);

		/*Specify numentries: */
		VecGetSize(yg->vector,&gsize);
	}

	/*Assign output pointers: */
	*pyg=yg;
}
