/*!\file: SortDataSets.cpp
 * \brief sort datasets created in CreateDataSets
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "./ModelProcessorx.h"


void SortDataSets(DataSet** pelements,DataSet** pnodes,DataSet** pvertices, DataSet** ploads, DataSet** pmaterials, DataSet** pconstraints, Parameters** pparameters){

	/*All our datasets are already ordered by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */

	if(*pelements)*pelements->Presort();
	if(*pnodes)*pnodes->Presort();
	if(*pvertices)*pvertices->Presort();
	if(*pmaterials)*pmaterials->Presort();
	if(*ploads)*ploads->Presort();
	if(*pconstraints)*pconstraints->Presort();
	if(*pparameters)*pparameters->Presort();

}
