/*
 * CreateNodesBalancedthickness2.c:
 */

#include "../../../DataSet/DataSet.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesBalancedthickness2(DataSet** pelements,DataSet** pnodes, DataSet** pvertices,DataSet** pmaterials, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i;
	int totalnodes;
	bool continuous_galerkin=false;

	/*DataSets: */
	DataSet* nodes = NULL;

	/*First create nodes*/ 
	nodes = new DataSet(NodesEnum);

	/*Recover number of nodes already created in other analyses: */
	totalnodes=iomodel->nodecounter;

	/*Continuous Galerkin partition of nodes: */
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements, iomodel->my_vertices, iomodel->my_bordervertices, iomodel, iomodel_handle,continuous_galerkin);

	/*Create nodes: */
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->gridonsurface,NULL,NULL,iomodel_handle,"gridonsurface");
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");
	IoModelFetchData(&iomodel->gridonicesheet,NULL,NULL,iomodel_handle,"gridonicesheet");
	IoModelFetchData(&iomodel->gridoniceshelf,NULL,NULL,iomodel_handle,"gridoniceshelf");
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	if (iomodel->dim==3){
		IoModelFetchData(&iomodel->deadgrids,NULL,NULL,iomodel_handle,"deadgrids");
		IoModelFetchData(&iomodel->uppernodes,NULL,NULL,iomodel_handle,"uppergrids");
		ISSMERROR("Not implemented yet");
	}

	/*Build Nodes dataset -> 3 for each element (Discontinuous Galerkin)*/
	for (i=0;i<iomodel->numberofelements;i++){
		for (j=0;j<3;j++){

			if(iomodel->my_nodes[3*i+j]){ 

				//Get index of the vertex on which the current node is located
				vertex_index=(int)*(iomodel->elements+3*i+j)-1; //(Matlab to C indexing)
				ISSMASSERT(vertex_index>=0 && vertex_index<iomodel->numberofvertices);

				//Compute Node index (id-1)
				node_index=3*i+j;

				/*Add node to nodes dataset: */
				nodes->AddObject(new Node(i+1,vertex_index,node_index,iomodel));

			}
		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->deadgrids);
	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->gridonsurface);
	xfree((void**)&iomodel->gridonhutter);
	xfree((void**)&iomodel->uppernodes);
	xfree((void**)&iomodel->gridonicesheet);
	xfree((void**)&iomodel->gridoniceshelf);
	xfree((void**)&iomodel->elements);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	nodes->Presort();

	/*Assign output pointer: */
	*pnodes=nodes;
}
