function fields=testsgetfields(md,sequence),
%TESTSGETFIELDS - build the fields to be checked from a analysis
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   for an input analysis 'prognostic', it will output 'prognostic.thickness'
%
%   Usage:
%      fields=testsgetfields(md,analysis)
%
%   Example:
%      fields=testsgetfields(md,'DiagnosticAnalysis')
%
%   See also: TESTSGETANALYSIS, TESTGETPACKAGE

%recover what is being requested.
analysis_type=sequence{1};
sub_analysis_type=sequence{2};
qmu=sequence{3};
control=sequence{4};
control_fit=sequence{5};
parallel=sequence{6};

if (analysis_type==DiagnosticAnalysisEnum),
	if control,
		fields={'DiagnosticAnalysis.vel','DiagnosticAnalysis.J','DiagnosticAnalysis.parameter'};
	elseif qmu,
		fields={'dakota.importancefactors'};
	else
		if md.dim==3
			fields={'DiagnosticAnalysis.vy','DiagnosticAnalysis.vz'};
		else
			fields={'DiagnosticAnalysis.vel'};
		end
	end

elseif (analysis_type==ThermalAnalysisEnum),
	fields={'ThermalAnalysis(end).temperature','ThermalAnalysis(end).melting'};

elseif (analysis_type==PrognosticAnalysisEnum),
	fields={'PrognosticAnalysis.thickness'};

elseif (analysis_type==Prognostic2AnalysisEnum),
	fields={'Prognostic2Analysis.thickness'};

elseif (analysis_type==TransientAnalysisEnum), 
	if md.dim==3
		fields={'TransientAnalysis(end).vel','TransientAnalysis(end).pressure','TransientAnalysis(end).temperature','TransientAnalysis(end).melting','TransientAnalysis(end).thickness','TransientAnalysis(end).surface','TransientAnalysis(end).bed'};
	else
		fields={'TransientAnalysis(end).vel','TransientAnalysis(end).thickness','TransientAnalysis(end).surface','TransientAnalysis(end).bed'};
	end

elseif (analysis_type==SteadystateAnalysisEnum), 
	if control,
		fields={'SteadystateAnalysis.vel','SteadystateAnalysis.J','SteadystateAnalysis.parameter'};
	else
		fields={'SteadystateAnalysis.vel','SteadystateAnalysis.pressure','SteadystateAnalysis.temperature'};
	end

elseif (analysis_type==BalancedthicknessAnalysisEnum), 
	fields={'BalancedthicknessAnalysis.thickness'};

elseif (analysis_type==SlopecomputeAnalysisEnum), 
	fields={'SlopecomputeAnalysis.slopex','SlopecomputeAnalysis.slopey'};

else
	error(['testsgetfields error message: requested sequence not supported yet']);
end
