function [x y z elements is2d]=processmesh(md,options);
%PROCESSMESH - process mesh to be plotted
%
%   Usage:
%      [x y z elements is2d]=processmesh(md,options)
%
%   See also: PLOTMODEL, PROCESSDATA

%some checks
if md.numberofgrids==md.numberofelements
	error('plot error message: the number of elements is the same as the number of grids! cannot plot anything with model/plot, use matlab/plot instead')
end

%first load x,y, etc ... to speed up plot
x=md.x;
x2d=md.x2d;
y=md.y;
y2d=md.y2d;
z=md.z;
z2d=md.z2d;
elements2d=md.elements2d;
elements=md.elements;
elements_type2d=md.elements_type2d;

%is it a 2d plot?
if (md.dim==2);
	is2d=1;
else
	if getfieldvalue(options,'layer',0)>=1,
		is2d=1;
	else
		is2d=0;
	end
end

%layer projection? 
if getfieldvalue(options,'layer',0)>=1,
	%we modify the mesh temporarily to a 2d mesh from which the 3d mesh was extruded. 
	x=x2d;
	y=y2d;
	z=z2d;
	elements=elements2d;
	elements_type=elements_type2d;
end

%units
if exist(options,'unit'),
	unit=getfieldvalue(options,'unit');
	x=x*unit;
	y=y*unit;
	z=z*unit;
end
