function  vector_average=DepthAverage(md,vector);
%DEPTHAVERAGE - computes depth average of 3d vector, and return value on 2d mesh. 
%
%   Usage:
%      vector_average=DepthAverage(md,vector);
%
%   Example:
%      vel_bar=DepthAverage(md,md.vel);

%check that the model given in input is 3d
if ~md.dim==3;
	error('DepthAverage error message: the model given in input must be 3d')
end

%nods data
if (length(vector)==md.numberofgrids),
	vector_average=zeros(md.numberofgrids2d,1);
	for i=1:md.numlayers-1,
		vector_average=vector_average+(project2d(md,vector,i)+project2d(md,vector,i+1))/2.*(project2d(md,md.z,i+1)-project2d(md,md.z,i));
	end
	vector_average=vector_average./project2d(md,md.thickness,1);

%element data
elseif (length(vector)==md.numberofelements),
	vector_average=zeros(md.numberofelements2d,1);
	for i=1:md.numlayers-1,
		vector_average=vector_average+project2d(md,vector,i).*(project2d(md,md.z,i+1)-project2d(md,md.z,i));
	end
	vector_average=vector_average./project2d(md,md.thickness,1);

else
	error('vector size not supported yet');
end
