/*
 * CreateNodesDiagnosticHoriz.c:
 */

#include "../../../DataSet/DataSet.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticHoriz(DataSet** pnodes, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i;
	bool galerkin_continuous=true;

	/*DataSets: */
	DataSet*    nodes = NULL;

	/*First create the elements, vertices, nodes and material properties, if they don't already exist */
	nodes     = new DataSet(NodesEnum);
	
	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!iomodel->ismacayealpattyn)goto cleanup_and_return;

	/*Recover number of nodes already created in other analyses: */
	totalnodes=iomodel->nodecounter;

	/*Galerkin continus partition of nodes: */
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements, iomodel->my_vertices, iomodel->my_bordervertices, iomodel, iomodel_handle,galerkin_continuous);

	/*Create nodes: */
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->gridonsurface,NULL,NULL,iomodel_handle,"gridonsurface");
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");
	IoModelFetchData(&iomodel->gridonicesheet,NULL,NULL,iomodel_handle,"gridonicesheet");
	IoModelFetchData(&iomodel->gridoniceshelf,NULL,NULL,iomodel_handle,"gridoniceshelf");
	if (iomodel->dim==3){
		IoModelFetchData(&iomodel->deadgrids,NULL,NULL,iomodel_handle,"deadgrids");
		IoModelFetchData(&iomodel->uppernodes,NULL,NULL,iomodel_handle,"uppergrids");
	}
	
	for (i=0;i<iomodel->numberofvertices;i++){

		if(iomodel->my_vertices[i]){
			
			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(totalnodes+i+1,i,iomodel,DiagnosticHorizAnalysisEnum));
		}
	}

	/*Increase nodecounter for other analyses to start their node indexing correctly: */
	totalnodes+=iomodel->numberofvertices;
	iomodel->nodecounter=totalnodes;

	/*Clean fetched data: */
	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->gridonsurface);
	xfree((void**)&iomodel->gridonhutter);
	xfree((void**)&iomodel->gridonicesheet);
	xfree((void**)&iomodel->gridoniceshelf);
	xfree((void**)&iomodel->deadgrids);
	xfree((void**)&iomodel->uppernodes);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	nodes->Presort();

	/*Assign output pointer: */
	*pnodes=nodes;

}
