/*
 * FemModel.h: 
 */

#ifndef _FEMMODEL_H_
#define _FEMMODEL_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
#include "../toolkits/toolkits.h"
class DataSet;
class Parameters;
class DofVec;
class NodeSets;
/*}}}*/


class FemModel {

	/*no private members, as we need access to these datasets quite often!:*/

	public:

		int                 nummodels;
		int*                analysis_type_list; //list of analyses this femmodel is going to carry out
		int                 analysis_counter; //counter into analysis_type_list
		
		DataSet*            elements; //elements (one set for all analyses)
		DataSet*            nodes; //one set of nodes
		DataSet*            vertices; //one set of vertices
		DataSet*            constraints; //one set of constraints. each constraint knows which analysis_type it handles
		DataSet*            loads;  //one set of constraints. each constraint knows which analysis_type it handles
		DataSet*            materials;  //one set of materials, for each element
		Parameters*         parameters; //one set of parameters, independent of the analysis_type

		DofVec*             partition; //one partitioning for all elements
		DofVec*             tpartition;
		
		//multiple  sets of matrices/vectors for each analysis_type
		Mat*                 Rmg; //rigid body motions matrices
		Mat*                 Gmn;
		NodeSets**           nodesets; //boundary conditions dof sets
		Vec*             yg; //boundary conditions in global g-set
		Vec*                 ys; //boundary conditions, in reduced s-set

		/*constructors, destructors: */
		FemModel(int nummodels);
		~FemModel();

		/*Methods: */
		Echo();

		/*Fem: */
		void  AddAnalysis(ConstDataHandle IOMODEL, int analysis_type);
		int   SetCurrentAnalysis(int analysis_type);
		void  GetCurrentAnalysis(void);

};


#endif
