/*!\file: TriaHook.h
 * \brief prototypes for TriaHook.h
 */ 

#ifndef _TRIAHOOK_H_
#define  _TRIAHOOK_H_

class Hook;

class TriaHook{

	public: 
		int   numanalyses; //number of analysis types
		Hook* hnodes; // 3 nodes for each analysis type
		Hook hmatice; // 1 ice material
		Hook hmatpar; // 1 material parameter


		/*FUNCTION constructors, destructors {{{1*/
		TriaHook();
		~TriaHook();
		void InitHookNodes(int numanalyses);
		void SetHookNodes(int* node_ids,int analysis_counter);
		void InitHookMatice(int matice_id);
		void InitHookMatpar(int matpar_id);
		void InitHookNeighbors(int* element_ids);

		/*}}}*/

};


#endif //ifndef _TRIAHOOK_H_

