/*!\file PentaHook.c
 * \brief: implementation of the PentaHook object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION PentaHook::PentaHook(){{{1*/
PentaHook::PentaHook(){
	numanalyses=UNDEF;
	this->hooks=NULL;
}
/*}}}*/
/*FUNCTION PentaHook::~PentaHook(){{{1*/
PentaHook::~PentaHook(){
	xfree((void**)&hnodes);
}
/*}}}*/
/*FUNCTION PentaHook::InitHookNodes(int numanalyses){{{1*/
void PentaHook::InitHookNodes(int numanalyses){
	this->hnodes=(Hook*)xmalloc(numanalyses*sizeof(Hook));
}
/*}}}*/
/*FUNCTION PentaHook::SetHookNodes(int* node_ids,int analysis_counter){{{1*/
void PentaHook::SetHookNodes(int* node_ids,int analysis_counter){
	this->hnodes[analysis_counter].Init(node_ids,6);

}
/*}}}*/
/*FUNCTION PentaHook::InitHookMatice(int matice_id){{{1*/
void PentaHook::InitHookMatice(int matice_id){
	this->hmatice.Init(&matice_id,1);
}

/*FUNCTION PentaHook::InitHookMatpar(int matpar_id){{{1*/
void PentaHook::InitHookMatpar(int matpar_id){
	this->hmatpar.Init(&matpar_id,1);
}

/*FUNCTION PentaHook::InitHookNeighbors(int* element_ids){{{1*/
void PentaHook::InitHookNeighbors(int* element_ids){
	this->hneighbors.Init(element_ids,2);

}
/*}}}*/
