/* \file ModelProcessorx.h
 * \brief  Header file for model processor
 */

#ifndef _MODEL_PROCESSORX_H_
#define _MODEL_PROCESSORX_H_

#define RIFTINFOSIZE 11

class DataSet;
class IoModel;
class Parameters;
#include "../../io/io.h"

/*Creation of fem datasets: general drivers*/
void    CreateDataSets(DataSet** pelements,DataSet** pnodes,DataSet** pvertices, DataSet** pmaterials, DataSet** pconstraints, DataSet** ploads,Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int analysis_type,int nummodels,int analysis_counter);
void    CreateElementsVerticesAndMaterials(DataSet** pelements,DataSet** pvertices,DataSet** pmaterials, IoModel* iomodel,ConstDataHandle iomodel_handle,int nummodels);
void    CreateParameters(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateParametersControl(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateParametersQmu(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle);

/*Creation of fem datasets: specialised drivers: */

/*diagnostic horizontal*/
void	CreateNodesDiagnosticHoriz(pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticHoriz(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsDiagnosticHoriz(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsDiagnosticHoriz(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);

/*diagnostic vertical*/
void	CreateNodesDiagnosticVert(pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticVert(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsDiagnosticVert(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElements(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);

/*diagnostic hutter*/
void	CreateNodesDiagnosticHutter(pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticHutter(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsDiagnosticHutter(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElements(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);

/*diagnostic stokes*/
void	CreateNodesDiagnosticStokes(pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticStokes(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsDiagnosticStokes(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElements(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);

/*slope compute*/
void	CreateNodesSlopeCompute(pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsSlopeCompute(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsSlopeCompute(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElements(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);

/*thermal:*/
void	CreateNodesThermal(pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsThermal(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsThermal(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElements(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);

/*melting:*/
void	CreateNodesMelting(pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsMelting(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsMelting(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElements(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);

/*prognostic:*/
void	CreateNodesPrognostic(pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsPrognostic(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsPrognostic(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElements(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);

/*prognostic2:*/
void	CreateNodesPrognostic2(pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsPrognostic2(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsPrognostic2(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElements(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);

/*balancedthickness:*/
void	CreateNodesBalancedthickness(pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsBalancedthickness(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsBalancedthickness(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElements(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);

void	CreateNodesBalancedthickness2(pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsBalancedthickness2(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsBalancedthickness2(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElements(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);

/*balancedvelocities:*/
void	CreateNodesBalancedvelocities(pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsBalancedvelocities(DataSet** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void    CreateLoadsBalancedvelocities(DataSet** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElements(DataSet* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);

/*partitioning: */
void    ElementsAndVerticesPartitioning(bool** pmy_elements, bool** pmy_vertices, bool** pmy_bordervertices, IoModel* iomodel, ConstDataHandle iomodel_handle);
void    NodesPartitioning(bool** pmy_nodes,bool* my_elements, bool* my_vertices, bool* my_bordervertices, IoModel* iomodel, ConstDataHandle iomodel_handle,bool continuous);

/*Connectivity*/
void    CreateSingleNodeToElementConnectivity(IoModel* iomodel);
void    CreateNumberNodeToElementConnectivity(IoModel* iomodel);

#endif
