/*!\file: CreateDataSets
 * \brief general driver for creating all datasets that make a finite element iomodel
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "./ModelProcessorx.h"


void CreateDataSets(DataSet** pelements,DataSet** pnodes, DataSet** pvertices, DataSet** pmaterials, DataSet** pconstraints, DataSet** ploads,Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int analysis_type){

	/*First, partition elements and vertices. Nodes will partitioned on a per analysis_type basis: */
	VerticesPartitioning(&iomodel->my_elements, &iomodel->my_vertices, &iomodel->my_bordervertices, iomodel, iomodel_handle);

	/*create parameters common to all solutions: */
	CreateParameters(pparameters,iomodel,iomodel_handle);
	
	CreateParametersControl(pparameters,iomodel,iomodel_handle);

	/*This is just a high level driver: */
	if (analysis_type==DiagnosticHorizAnalysisEnum){
		CreateElementsNodesAndMaterialsDiagnosticHoriz(pelements,pnodes, pvertices, pmaterials, iomodel,iomodel_handle);
		CreateConstraintsDiagnosticHoriz(pconstraints,iomodel,iomodel_handle);
		CreateLoadsDiagnosticHoriz(ploads,iomodel,iomodel_handle);
	}
	else if (analysis_type==DiagnosticVertAnalysisEnum){

		CreateElementsNodesAndMaterialsDiagnosticVert(pelements,pnodes, pvertices, pmaterials, iomodel,iomodel_handle);
		CreateConstraintsDiagnosticVert(pconstraints,iomodel,iomodel_handle);
		CreateLoadsDiagnosticVert(ploads,iomodel,iomodel_handle);
	}
	else if (analysis_type==DiagnosticStokesAnalysisEnum){

		CreateElementsNodesAndMaterialsDiagnosticStokes(pelements,pnodes, pvertices, pmaterials, iomodel,iomodel_handle);
		CreateConstraintsDiagnosticStokes(pconstraints,iomodel,iomodel_handle);
		CreateLoadsDiagnosticStokes(ploads,iomodel,iomodel_handle);
	}
	else if (analysis_type==DiagnosticHutterAnalysisEnum){

		CreateElementsNodesAndMaterialsDiagnosticHutter(pelements,pnodes,pvertices, pmaterials, iomodel,iomodel_handle);
		CreateConstraintsDiagnosticHutter(pconstraints,iomodel,iomodel_handle);
		CreateLoadsDiagnosticHutter(ploads,iomodel,iomodel_handle);
	}
	else if (analysis_type==SlopecomputeAnalysisEnum){

		CreateElementsNodesAndMaterialsSlopeCompute(pelements,pnodes, pvertices,pmaterials, iomodel,iomodel_handle);
		CreateConstraintsSlopeCompute(pconstraints,iomodel,iomodel_handle);
		CreateLoadsSlopeCompute(ploads,iomodel,iomodel_handle);
	}
	else if (analysis_type==ThermalAnalysisEnum){

		CreateElementsNodesAndMaterialsThermal(pelements,pnodes,pvertices, pmaterials, iomodel,iomodel_handle);
		CreateConstraintsThermal(pconstraints,iomodel,iomodel_handle);
		CreateLoadsThermal(ploads,iomodel,iomodel_handle);

	}
	else if (analysis_type==MeltingAnalysisEnum){

		CreateElementsNodesAndMaterialsMelting(pelements,pnodes,pvertices, pmaterials, iomodel,iomodel_handle);
		CreateConstraintsMelting(pconstraints,iomodel,iomodel_handle);
		CreateLoadsMelting(ploads,iomodel,iomodel_handle);
	}
	else if (analysis_type==PrognosticAnalysisEnum){

		CreateElementsNodesAndMaterialsPrognostic(pelements,pnodes,pvertices, pmaterials, iomodel,iomodel_handle);
		CreateConstraintsPrognostic(pconstraints,iomodel,iomodel_handle);
		CreateLoadsPrognostic(ploads,iomodel,iomodel_handle);
	}
	else if (analysis_type==Prognostic2AnalysisEnum){

		CreateElementsNodesAndMaterialsPrognostic2(pelements,pnodes,pvertices, pmaterials, iomodel,iomodel_handle);
		CreateConstraintsPrognostic2(pconstraints,iomodel,iomodel_handle);
		CreateLoadsPrognostic2(ploads,iomodel,iomodel_handle);
	}
	else if (analysis_type==BalancedthicknessAnalysisEnum){

		CreateElementsNodesAndMaterialsBalancedthickness(pelements,pnodes,pvertices, pmaterials, iomodel,iomodel_handle);
		CreateConstraintsBalancedthickness(pconstraints,iomodel,iomodel_handle);
		CreateLoadsBalancedthickness(ploads,iomodel,iomodel_handle);
	}
	else if (analysis_type==Balancedthickness2AnalysisEnum){

		CreateElementsNodesAndMaterialsBalancedthickness2(pelements,pnodes,pvertices, pmaterials, iomodel,iomodel_handle);
		CreateConstraintsBalancedthickness2(pconstraints,iomodel,iomodel_handle);
		CreateLoadsBalancedthickness2(ploads,iomodel,iomodel_handle);
	}
	else if (analysis_type==BalancedvelocitiesAnalysisEnum){

		CreateElementsNodesAndMaterialsBalancedvelocities(pelements,pnodes,pvertices,pmaterials, iomodel,iomodel_handle);
		CreateConstraintsBalancedvelocities(pconstraints,iomodel,iomodel_handle);
		CreateLoadsBalancedvelocities(ploads,iomodel,iomodel_handle);
	}
	else{
		ISSMERROR("%s%i%s%i%s"," analysis_type: ",analysis_type," analysis_type: ",analysis_type," not supported yet!");

	}
	CreateParametersQmu(pparameters,iomodel,iomodel_handle);

}
