function results=balancedthickness_core(models,analysis_type,sub_analysis_type)
%BALANCEDTHICKNESS_CORE - linear solution sequence
%
%   Usage:
%      h_g=balancedthickness_core(m,analysis_type,sub_analysis_type)

	%get FE model
	verbose=models.bt.parameters.Verbose;
	results.time=0;
	results.step=1;

	displaystring(verbose,'\n%s',['depth averaging velocity...']);
	[models.bt.elements,models.bt.nodes,models.bt.vertices,models.bt.loads,models.bt.materials,models.bt.parameters]=DepthAverageInput(models.bt.elements,models.bt.nodes,models.bt.vertices,models.bt.loads,models.bt.materials,models.bt.parameters,VxEnum);
	[models.bt.elements,models.bt.nodes,models.bt.vertices,models.bt.loads,models.bt.materials,models.bt.parameters]=DepthAverageInput(models.bt.elements,models.bt.nodes,models.bt.vertices,models.bt.loads,models.bt.materials,models.bt.parameters,VyEnum);

	displaystring(verbose,'\n%s',['call computational core:']);
	h_g=diagnostic_core_linear(models.bt,analysis_type,sub_analysis_type);

	%Update
	models.bt.elements=UpdateInputsFromSolution(models.bt.elements,models.bt.nodes,models.bt.vertices,models.bt.loads,models.bt.materials,models.bt.parameters,h_g,BalancedthicknessAnalysisEnum,NoneAnalysisEnum);

	displaystring(verbose,'\n%s',['extrude computed thickness on all layers:']);
	models.bt.elements=ExtrudeInput(models.bt.elements,models.bt.nodes,models.bt.vertices,models.bt.loads,models.bt.materials,models.bt.parameters,ThicknessEnum);

	%NEED TO BE CLEANED
	results.h_g=h_g;
end %end function
