function md=balancedthickness(md)
%BALANCEDTHICKNESS - balancedthickness solution sequence.
%
%   Usage:
%      md=balancedthickness(md)

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	models.analysis_type=BalancedthicknessAnalysisEnum; %needed for processresults
	
	displaystring(md.verbose,'%s',['reading balancedthickness model data']);
	md.analysis_type=BalancedthicknessAnalysisEnum; models.bt=CreateFemModel(md);

	% figure out number of dof: just for information purposes.
	md.dof=modelsize(models);

	%compute solution
	displaystring(md.verbose,'\n%s',['call computational core:']);
	results=balancedthickness_core(models,BalancedthicknessAnalysisEnum(),NoneAnalysisEnum());

	displaystring(md.verbose,'\n%s',['load results...']);
	if ~isstruct(md.results), md.results=struct(); end
	md.results.BalancedthicknessAnalysis=processresults(models,results);

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);	
