/*!\file DepthAverageInputx
 * \brief: average field throfieldh thickness
 */

#include "./DepthAverageInputx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void DepthAverageInputx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,int enum_type){
	
	/*Intermediary*/
	int i;
	Element* element=NULL;

	/*First, get elements*/
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*First depth-average inputs at base of the glacier*/
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->DepthAverageInputAtBase(enum_type);
	}

	/*Then extrude vertically the new inputs*/
	elements->InputExtrude(enum_type);

}
