/*!\file UpdateVertexPositionsx
 * \brief update vertex positions using new geometry defined by new thickness and new bed.
 */

#include "./UpdateVertexPositionsx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void UpdateVertexPositionsx( DataSet* vertices, Vec thickness,Vec bed){

	/*intermediary: */
	int i;
	Vertex* vertex=NULL;
	double* thickness_serial=NULL;
	double* bed_serial=NULL;

	/*serialize inputs: */
	VecToMPISerial(&thickness_serial,thickness);
	VecToMPISerial(&bed_serial,bed);
	
	/*Update verices new geometry: */
	for (i=0;i<vertices->Size();i++){
		vertex=(Vertex*)vertices->GetObjectByOffset(i);
		vertex->UpdatePosition(thickness_serial,bed_serial);
	}

	/*Free ressources:*/
	xfree((void**)&thickness_serial);
	xfree((void**)&bed_serial);
}
