/*!\file FieldDepthAveragex
 * \brief: average field throfieldh thickness
 */

#include "./FieldDepthAveragex.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void FieldDepthAveragex( Vec field, DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,char* fieldname){

	/*Intermediary*/
	int i;
	double* field_serial=NULL;
	Node*   node=NULL;

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Serialize field: */
	VecToMPISerial(&field_serial,field);

	/*Depth average field, onto base of mesh: */
	for (i=0;i<nodes->Size();i++){
		node=(Node*)nodes->GetObjectByOffset(i);
		node->FieldDepthAverageAtBase(field,field_serial,fieldname);
	}

	/*Assemble vector: */
	VecAssemblyBegin(field);
	VecAssemblyEnd(field);

	/*ok, field is now correct at the base. We need to extrude the value of the base 
	 * through thickness :*/

	/*Serialize field: */
	xfree((void**)&field_serial);
	VecToMPISerial(&field_serial,field);

	/*Extrude field to all nodes: */
	nodes->FieldExtrude(field,field_serial,fieldname,0);

	/*Assemble vector: */
	VecAssemblyBegin(field);
	VecAssemblyEnd(field);

	/*Free ressources:*/
	xfree((void**)&field_serial);

}
