/*!\file ComputeStrainRatex
 * \brief: compute pressure according to each element
 */

#include "./ComputeStrainRatex.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void	ComputeStrainRatex( Vec* peps,DataSet* elements,DataSet* nodes, DataSet* vertices,DataSet* loads, DataSet* materials,Parameters* parameters,
			int analysis_type,int sub_analysis_type){

	/*Intermediary*/
	int i;
	int      found=0;
	double   numberofelements;
	Element* element=NULL;

	/*output: */
	Vec eps=NULL;

	/*Recover numberofelements: */
	parameters->FindParam(&numberofelements,NumberOfElementsEnum);

	/*Allocate eps on numberofelements (only 1 dof): */
	eps=NewVec(numberofelements);

	/*Get elements configured: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Compute basal stress for each element: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->ComputeStrainRate(eps,analysis_type,sub_analysis_type);
	}

	/*Assemble vector: */
	VecAssemblyBegin(eps);
	VecAssemblyEnd(eps);

	/*Assign output pointers: */
	*peps=eps;
	
}
