/*!\file ComputePressurex
 * \brief: compute pressure according to each element
 */

#include "./ComputePressurex.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void	ComputePressurex( Vec* pp_g,DataSet* elements,DataSet* nodes, DataSet* vertices,DataSet* loads, DataSet* materials,Parameters* parameters,
			int analysis_type,int sub_analysis_type){

	/*intermediary*/
	int numberofnodes;
	int i;
	Element* element=NULL;

	/*output: */
	Vec p_g=NULL;

	/*Recover numberofnodes: */
	parameters->FindParam(&numberofnodes,NumberOfNodesEnum);

	/*Allocate p_g on numberofnodes (only 1 dof): */
	p_g=NewVec(numberofnodes);

	/*Get elements configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements,loads,nodes,vertices,materials,parameters);
	parameters->Configure(elements,loads,nodes,vertices,materials,parameters);

	/*Compute pressure for each element: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->ComputePressure(p_g,analysis_type,sub_analysis_type);
	}

	/*Assemble vector: */
	VecAssemblyBegin(p_g);
	VecAssemblyEnd(p_g);

	/*Assign output pointers: */
	*pp_g=p_g;
	
}
