/*!\file Reducevectorgtosx
 * \brief reduce petsc vector from g set to s set (single point constraints), using the nodeset partitioning 
 * vectors.
 */

#include "./Reducevectorgtosx.h"

void Reducevectorgtosx( Vec* pys, Vec yg, NodeSets* nodesets){

	/*output: */
	Vec ys=NULL;

	/*intermediary: */
	Vec yn=NULL;

	if(nodesets){


		if (nodesets->GetNSize() && nodesets->GetSSize()){

			VecPartition(&yn,yg,nodesets->GetPV_N(),nodesets->GetNSize());
		
			VecPartition(&ys,yn,nodesets->GetPV_S(),nodesets->GetSSize());
		
		}

		/*Free ressources:*/
		VecFree(&yn);
	}
	
	/*Assign output pointer:*/
	*pys=ys;
}
