/*! \file SingVertexInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _SINGVERTEXINPUT_H_
#define _SINGVERTEXINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
/*}}}*/

class SingVertexInput: public Input{

	private: 
		/*just hold 1 value for 1 vertex: */
		int    enum_type;
		double value;

	public:

		/*constructors, destructors: {{{1*/
		SingVertexInput();
		SingVertexInput(int enum_type,double value);
		~SingVertexInput();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}

		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}

		Input* SpawnSingInput(int  index);
		Input* SpawnBeamInput(int* indices);
		Input* SpawnTriaInput(int* indices);
		/*}}}*/
		/*numerics: {{{1*/
		void GetParameterValue(bool* pvalue);
		void GetParameterValue(int* pvalue);
		void GetParameterValue(double* pvalue);
		void GetParameterValue(double* pvalue,Node* node);
		void GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord);
		void GetParameterValue(double* pvalue,double* gauss);
		void GetParameterValue(double* pvalue,double* gauss,double defaultvalue);
		
		void GetParameterAverage(double* pvalue);
		
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss);
	
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss);
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void ChangeEnum(int newenumtype);
		int  PatchSize(void);
		void PatchFill(double* patches, int max_vertices,Parameters* parameters);
		/*}}}*/

};
#endif  /* _SINGVERTEXINPUT_H */
