/*!\file InputToResultx
 * \brief: average field throfieldh thickness
 */

#include "./InputToResultx.h"

#include "../../shared/shared.h"
#include "../../objects/objects.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputToResultx(Result** presult,DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials,Parameters* parameters,int enum_type,int id, double time, int step){

	/*We are going to extract from the inputs, the results desired, and create a table 
	 * of patch information, that will hold, for each element that computed the result that 
	 * we desire, the id of the element, the interpolation type, the vertices ids, and the values 
	 * at the nodes (could be different from the vertices). This will be used for visualization purposed. 
	 * For example, we could build the following patch table, for velocities: 
	 * 
	 * 1 P0  1 2       4.5 NaN  NaN (constant on a beam element)
	 * 2 P1  1 3 4     4.5 3.2  2.5  (linear values on a tria element)
	 * 3 P0  1 5 4     5.5 NaN  NaN  (contant on a tria element)
	 * ... etc ...
	 *
	 * So what do we need to build the table: the maximum number of vertices included in the table, 
	 * and the maximum number of nodal values, as well as the number of rows. Once we have that, 
	 * we ask the elements to fill their own row in the table, by looping on the elememnts.
	 * Finally, we include the table in a Result object, that will be used by the OutputResults 
	 * module to write to disk: */

	int i,j,count;

	/*output: */
	Result* result=NULL;

	/*Intermediary output vector*/
	double* patches=NULL; //build a matrix of patch information, corresponding to the input with  name enum_type
	int     patch_numrows,patch_numcols;
	int     max_vertices;
	int     max_nodes;

	/*First, get elements*/
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Figure out size of patches matrix: */
	PatchesSize(elements,&patch_numrows, &max_vertices, &max_nodes, enum_type);

	patch_numcols=1+ //element id
		          1+ //interpolation type
				  max_vertices+ //vertices
				  max_nodes; //values+

	/*Allocate matrix: */
	patches=(double*)xmalloc(patch_numrows*patch_numcols*sizeof(double));

	/*Fill patches with NaN, default value: */
	for(i=0;i<patch_numrows;i++){
		for(j=0;j<patch_numcols;j++){
			*(patches+patch_numcols*i+j)=NAN;
		}
	}

	/*Now, go through elements, their inputs with the correct enum_type, and fill the patches: */
	InputToPatches(elements,patches,patch_numrows,max_vertices,enum_type); 

	/*Create result object embedding patches: */
	result=new DoubleMatResult(id,enum_type,time,step,patches,patch_numrows,patch_numcols);

	/*Assign output pointer*/
	*presult=result;

}




