/*
 * \file Results.c
 * \brief: implementation of the Results class, derived from DataSet class
 */

/*Headers: {{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <vector>
#include <functional>
#include <algorithm>
#include <iostream>

#include "./DataSet.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Results::Results(){{{1*/
Results::Results(){
	return;
}
/*}}}*/
/*FUNCTION Results::Results(int in_enum){{{1*/
Results::Results(int in_enum): DataSet(in_enum){
	//do nothing;
	return;
}
/*}}}*/
/*FUNCTION Results::~Results(){{{1*/
Results::~Results(){
	return;
}
/*}}}*/

/*Object methods*/
/*FUNCTION Results::FindResult(Vec* presult,char* name){{{1*/
int   Results::FindResult(Vec* presult,char* name){

	/*Go through a dataset, and find a Result* object 
	 *whith result name is "name" : */
	
	vector<Object*>::iterator object;
	Result* result=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Find param type objects: */
		if((*object)->Enum()==ResultEnum){

			/*Ok, this object is a result,recover it and ask which name it has: */
			result=(Result*)(*object);

			if (strcmp(result->GetFieldName(),name)==0){
				/*Ok, this is the one! Recover the value of this result: */
				result->GetField(presult);
				found=1;
				break;
			}
		}
	}
	return found;
}
/*}}}*/
/*FUNCTION Results::FindResult(void* pvalue, char* name){{{1*/
int   Results::FindResult(void* pvalue, char* name){

	/*Go through a dataset, and find a Result* object 
	 *which field name is "name" : */
	
	vector<Object*>::iterator object;
	Result* result=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Find param type objects: */
		if((*object)->Enum()==ResultEnum){

			/*Ok, this object is a result, recover it and ask which name it has: */
			result=(Result*)(*object);

			if (strcmp(result->GetFieldName(),name)==0){
				/*Ok, this is the one! Recover the value of this result: */
				double** field=NULL;
				field=(double**)pvalue; //not very safe, but hey!
				result->GetField(field);
				found=1;
				break;
			}
		}
	}
	return found;
}
/*}}}*/
