function [u_g varargout]=diagnostic_core_nonlinear(m,inputs,analysis_type)
%INPUT function [ru_g varargout]=cielodiagnostic_core_nonlinear(m,inputs)
	
%   first off! We are going to modify the loads dataset. We need to shield the loads from those changes once we return;
	loads=m.loads;

%	stiffness and load generation only:
	m.parameters.kflag=1; m.parameters.pflag=1;

%   initialize solution vector
	count=1;
	converged=0;

	soln(count).u_g=get(inputs,'velocity',[1 1 (m.parameters.numberofdofspernode>=3) (m.parameters.numberofdofspernode>=3)]); %only keep vz if running with more than 3 dofs per node
	soln(count).u_f=[];

	displaystring(m.parameters.debug,'\n%s',['   starting direct shooting method']);
	while(~converged),
		
		%add velocity to inputs
		inputs=add(inputs,'velocity',soln(count).u_g,'doublevec',m.parameters.numberofdofspernode,m.parameters.numberofnodes);
		if count>1,
			inputs=add(inputs,'old_velocity',soln(count-1).u_g,'doublevec',m.parameters.numberofdofspernode,m.parameters.numberofnodes);
		else
			inputs=add(inputs,'old_velocity',soln(count).u_g,'doublevec',m.parameters.numberofdofspernode,m.parameters.numberofnodes);
		end

		%Update inputs in datasets
		[m.elements,m.nodes, loads,m.materials]=UpdateFromInputs(m.elements,m.nodes, loads,m.materials,inputs);
		
		%system matrices 
		[K_gg_nopenalty , p_g_nopenalty]=SystemMatrices(m.elements,m.nodes,loads,m.materials,m.parameters,inputs,analysis_type);
		
		%penalties
		[K_gg , p_g]=PenaltySystemMatrices(K_gg_nopenalty,p_g_nopenalty,m.elements,m.nodes,loads,m.materials,m.parameters,inputs,analysis_type);


		%Reduce tangent matrix from g size to f size
		[K_ff, K_fs] = Reducematrixfromgtof( K_gg, m.Gmn, m.nodesets); 

		%Reduce load from g size to f size
		[p_f] = Reduceloadfromgtof( p_g, m.Gmn, K_fs, m.ys, m.nodesets);

		%Increment index
		count=count+1;

		%Solve	
		displaystring(m.parameters.debug,'%s%g','      condition number of stiffness matrix: ',condest(K_ff));
		[soln(count).u_f]=Solver(K_ff,p_f,[],m.parameters);
	
		%Merge back to g set
		[soln(count).u_g]= Mergesolutionfromftog( soln(count).u_f, m.Gmn, m.ys, m.nodesets ); 

		if (count>2),
			soln(count-1).u_f=NaN;
		end

		%Deal with penalty loads
		inputs=add(inputs,'velocity',soln(count).u_g,'doublevec',m.parameters.numberofdofspernode,m.parameters.numberofnodes);
	
		%penalty constraints
		[loads,constraints_converged,num_unstable_constraints] =PenaltyConstraints( m.elements,m.nodes, loads, m.materials,m.parameters,inputs);

	%   Figure out if convergence is reached.
		dug=soln(count).u_g-soln(count-1).u_g; 
		nduinf=norm(dug,inf)*m.parameters.yts; 
		ndu=norm(dug,2); 
		nu=norm(soln(count-1).u_g,2); 

		%Relative criterion
		if (ndu/nu<=m.parameters.eps_rel),
			displaystring(m.parameters.debug,'%s%g%s%g','      convergence criterion: norm(du)/norm(u)=',ndu/nu,' < ',m.parameters.eps_rel);
			converged=1;
		else
			displaystring(m.parameters.debug,'%s%g%s%g','      convergence criterion: norm(du)/norm(u)=',ndu/nu,' > ',m.parameters.eps_rel);
			converged=0;
		end

		%Absolute criterion
		if ~isnan(m.parameters.eps_abs),
			if (nduinf<=m.parameters.eps_abs),
				displaystring(m.parameters.debug,'%s%g%s%g','      convergence criterion: max(du)=',nduinf,' < ',m.parameters.eps_abs);
			else
				displaystring(m.parameters.debug,'%s%g%s%g','      convergence criterion: max(du)=',nduinf,' > ',m.parameters.eps_abs);
				converged=0;
			end
		end

		%rift convergence criterion
		if ~constraints_converged,
			converged=0;
		end

		%if (count>2),
		%	soln(count-1).u_g=NaN;
		%end
	end
			
	%some cleanup
	[soln(count).u_f]=NaN;

	u_g=soln(count).u_g;

	%more output might be needed, when running in cielocontrol.m
	nout=max(nargout,1)-1;
	if nout==2,
		inputs=add(inputs,'velocity',soln(count).u_g,'doublevec',m.parameters.numberofdofspernode,m.parameters.numberofnodes);
		m.parameters.kflag=1; m.parameters.pflag=0; 
		[K_gg, p_g]=SystemMatrices(m.elements,m.nodes,loads,m.materials,m.parameters,inputs,analysis_type);
		[K_ff, K_fs] = Reducematrixfromgtof( K_gg, m.Gmn, m.nodesets); 
		varargout(1)={K_ff};
		varargout(2)={K_fs};
	end
end
