/*!\file BeamVertexInput.c
 * \brief: implementation of the BeamVertexInput object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "./InputLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"

/*Object constructors and destructor*/
/*FUNCTION BeamVertexInput::BeamVertexInput(){{{1*/
BeamVertexInput::BeamVertexInput(){
	return;
}
/*}}}*/
/*FUNCTION BeamVertexInput::BeamVertexInput(double* values){{{1*/
BeamVertexInput::BeamVertexInput(int in_enum_type,double* in_values){

	enum_type=in_enum_type;
	values[0]=in_values[0];
	values[1]=in_values[1];
}
/*}}}*/
/*FUNCTION BeamVertexInput::~BeamVertexInput(){{{1*/
BeamVertexInput::~BeamVertexInput(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION BeamVertexInput::copy{{{1*/
Object* BeamVertexInput::copy() {
	
	return new BeamVertexInput(this->enum_type,this->values);

}
/*}}}*/
/*FUNCTION BeamVertexInput::DeepEcho{{{1*/
void BeamVertexInput::DeepEcho(void){

	printf("BeamVertexInput:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   values: [%g %g]\n",this->values[0],this->values[1]);
}
/*}}}*/
/*FUNCTION BeamVertexInput::Demarshall{{{1*/
void  BeamVertexInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&values,marshalled_dataset,sizeof(values));marshalled_dataset+=sizeof(values);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION BeamVertexInput::Echo {{{1*/
void BeamVertexInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION BeamVertexInput::Enum{{{1*/
int BeamVertexInput::Enum(void){

	return BeamVertexInputEnum;

}
/*}}}*/
/*FUNCTION BeamVertexInput::EnumType{{{1*/
int BeamVertexInput::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION BeamVertexInput::Id{{{1*/
int    BeamVertexInput::Id(void){ return -1; }
/*}}}*/
/*FUNCTION BeamVertexInput::Marshall{{{1*/
void  BeamVertexInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of BeamVertexInput: */
	enum_value=BeamVertexInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall BeamVertexInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&values,sizeof(values));marshalled_dataset+=sizeof(values);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION BeamVertexInput::MarshallSize{{{1*/
int   BeamVertexInput::MarshallSize(){
	
	return sizeof(values)+
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum_value
}
/*}}}*/
/*FUNCTION BeamVertexInput::MyRank{{{1*/
int    BeamVertexInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION BeamVertexInput::SpawnSingInput{{{1*/
Input* BeamVertexInput::SpawnSingInput(int index){

	/*output*/
	SingVertexInput* outinput=NULL;

	/*Create new Sing input (copy of current input)*/
	ISSMASSERT(index<2 && index>=0);
	outinput=new SingVertexInput(this->enum_type,this->values[index]);

	/*Assign output*/
	return outinput;

}
/*}}}*/
/*FUNCTION BeamVertexInput::SpawnBeamInput{{{1*/
Input* BeamVertexInput::SpawnBeamInput(int* indices){

	/*output*/
	BeamVertexInput* outinput=NULL;

	/*Create new Beam input (copy of current input)*/
	outinput=new BeamVertexInput(this->enum_type,&this->values[0]);

	/*Assign output*/
	return outinput;

}
/*}}}*/
/*FUNCTION BeamVertexInput::SpawnTriaInput{{{1*/
Input* BeamVertexInput::SpawnTriaInput(int* indices){

	ISSMERROR("Cannot spaw a Tria from a Beam");

}
/*}}}*/

/*Object functions*/
/*FUNCTION BeamVertexInput::GetParameterValue(bool* pvalue) {{{1*/
void BeamVertexInput::GetParameterValue(bool* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterValue(int* pvalue){{{1*/
void BeamVertexInput::GetParameterValue(int* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterValue(double* pvalue){{{1*/
void BeamVertexInput::GetParameterValue(double* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterValue(double* pvalue,Node* node){{{1*/
void BeamVertexInput::GetParameterValue(double* pvalue,Node* node){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord){{{1*/
void BeamVertexInput::GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterValue(double* pvalue,double* gauss){{{1*/
void BeamVertexInput::GetParameterValue(double* pvalue,double* gauss){
	*pvalue=gauss[0]*values[0]+gauss[1]*values[1];
}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterValue(double* pvalue,double* gauss,double defaultvalue){{{1*/
void BeamVertexInput::GetParameterValue(double* pvalue,double* gauss,double defaultvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterValues(double* values,double* gauss_pointers, int numgauss){{{1*/
void BeamVertexInput::GetParameterValues(double* pvalues,double* gauss_pointers, int numgauss){
	/*It is assumed that output has been correctly allocated*/

	int i,j;
	double gauss[2];

	for(i=0;i<numgauss;i++){
		/*Get current Gauss point coordinates*/
		for (j=0;j<2;j++) gauss[j]=gauss_pointers[i*2+j];

		/*Assign parameter value*/
		GetParameterValue(&values[i],&gauss[0]);
	}
}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){{{1*/
void BeamVertexInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION BeamVertexInput::ChangeEnum(int newenumtype){{{1*/
void BeamVertexInput::ChangeEnum(int newenumtype){
	this->enum_type=newenumtype;
}
/*}}}*/
/*FUNCTION BeamVertexInput::GetParameterAverage(double* pvalue){{{1*/
void BeamVertexInput::GetParameterAverage(double* pvalue){
	*pvalue=1./2.*(values[0]+values[1]);
}
/*}}}*/
/*FUNCTION BeamVertexInput::PatchSize(void);{{{1*/
int BeamVertexInput::PatchSize(void){
	return 2;
}
/*}}}*/
/*FUNCTION BeamVertexInput::PatchFill(double* patches);{{{1*/
void BeamVertexInput::PatchFill(double* patches,Parameters* parameters){
	patches[0]=values[0];
	patches[1]=values[1];

	/*Now, post-processing: */
	ProcessResults(patches,2,this->enum_type,parameters);

}
/*}}}*/
