/*! \file PetscVecResult.h 
 *  \brief: header file for Vec result object
 */


#ifndef _PETSCVECRESULT_H_
#define _PETSCVECRESULT_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./Result.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class PetscVecResult: public Result{

	private: 
		int    id;
		int    enum_type;
		double time;
		int    step;

		Vec    value;

	public:
		/*constructors, destructors: {{{1*/
		PetscVecResult();
		PetscVecResult(int id, int enum_type,double time, int step, Vec value);
		~PetscVecResult();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();

		void  UpdateInputsFromVector(double* vector, int name, int type);
		void  UpdateInputsFromVector(int* vector, int name, int type);
		void  UpdateInputsFromVector(bool* vector, int name, int type);
		void  UpdateInputsFromConstant(double constant, int name);
		void  UpdateInputsFromConstant(int constant, int name);
		void  UpdateInputsFromConstant(bool constant, int name);
		void  UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}
		/*}}}*/
		/*Result methods: {{{1*/
		/*}}}*/
};
#endif  /* _PETSCVECRESULT_H */
