function md=slopecompute(md);
%SLOPECOMPUTE - compute the slope of a model
%
%   Usage:
%      md=slopecompute(md)
%
	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	models.analysis_type=SlopecomputeAnalysisEnum; %needed for processresults

	displaystring(md.verbose,'\n%s',['reading surface and bed slope computation model data']);
	md.analysis_type=SlopecomputeAnalysisEnum; md.sub_analysis_type=NoneAnalysisEnum; models.sl=CreateFemModel(md);
	
	% figure out number of dof: just for information purposes.
	md.dof=modelsize(models);

	%compute solution
	displaystring(md.verbose,'\n%s',['call computational core:']);
	results=slopecompute_core(models,SlopecomputeAnalysisEnum(),NoneAnalysisEnum());

	displaystring(md.verbose,'\n%s',['load results...']);
	if ~isstruct(md.results), md.results=struct(); end
	md.results.SlopeComputeAnalysis=processresults(models,results);

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
