function md=prognostic(md)
%PROGNOSITC - prognostic solution sequence.
%
%   Usage:
%      md=prognostic(md)

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	models.analysis_type=PrognosticAnalysisEnum; %needed for processresults
	
	displaystring(md.verbose,'%s',['reading prognostic model data']);
	md.analysis_type=PrognosticAnalysisEnum; models.p=CreateFemModel(md);

	% figure out number of dof: just for information purposes.
	md.dof=modelsize(models);

	displaystring(md.verbose,'\n%s',['call computational core:']);
	results=prognostic_core(models,PrognosticAnalysisEnum(),NoneAnalysisEnum());

	displaystring(md.verbose,'\n%s',['load results...']);
	if ~isstruct(md.results), md.results=struct(); end
	md.results.PrognosticAnalysis=processresults(models, results);

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);	
